package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ActivationRoll extends Modifier {

    private static String xmlID = "ACTIVATIONROLL";

    public ActivationRoll(Element root) {
        super(root, ActivationRoll.xmlID);
        for (Adder adder : getAvailableAdders()) {
            if (adder.getXMLID().equals("BURNOUT")) {
                adder.setSelectable(true);
                if (getOptions().size() > 1) {
                    int index = getOptions().indexOf(getSelectedOption());
                    if (getOptions().size() > index + 1) {
                        Adder mod = getOptions().get(index + 1);
                        adder.setBaseCost(Math.max(mod.getBaseCost()
                                - getSelectedOption().getBaseCost(), .25));
                    } else {
                        adder.setBaseCost(.25);
                    }
                }
            }
        }
    }

    @Override
    public void setSelectedOption(Adder option) {
        super.setSelectedOption(option);
        if (option != null) {
            baseCost = option.getBaseCost();
            Adder burnout = null;
            Adder assignedBurnout = null;
            for (Adder check : getAvailableAdders()) {
                if (check.getXMLID().equals("BURNOUT")) {
                    burnout = check;
                    break;
                }
            }
            for (Adder check : getAssignedAdders()) {
                if (check.getXMLID().equals("BURNOUT")) {
                    assignedBurnout = check;
                    break;
                }
            }
            if (burnout != null || assignedBurnout != null) {
                int index = getOptions().indexOf(getSelectedOption());
                if (index + 1 < getOptions().size()) {
                    Adder next = getOptions().get(index + 1);
                    if (burnout != null) {
                        burnout.setBaseCost(Math.max(next.getBaseCost()
                                - getSelectedOption().getBaseCost(), .25));
                        burnout.setMinimumCost(burnout.getBaseCost());
                        burnout.setMaxCost(burnout.getBaseCost());
                    }
                    if (assignedBurnout != null) {
                        assignedBurnout.setBaseCost(Math.max(next.getBaseCost()
                                - getSelectedOption().getBaseCost(), .25));
                        assignedBurnout.setMinimumCost(assignedBurnout
                                .getBaseCost());
                        assignedBurnout.setMaxCost(assignedBurnout
                                .getBaseCost());
                    }
                } else {
                    if (burnout != null) {
                        burnout.setBaseCost(.25);
                        burnout.setMinimumCost(burnout.getBaseCost());
                        burnout.setMaxCost(burnout.getBaseCost());
                    }
                    if (assignedBurnout != null) {
                        assignedBurnout.setBaseCost(.25);
                        assignedBurnout.setMinimumCost(assignedBurnout
                                .getBaseCost());
                        assignedBurnout.setMaxCost(assignedBurnout
                                .getBaseCost());
                    }
                }
            }
        }
    }

    @Override
    public String getColumn2Output() {
        String adderString = "";
        String ret = "";
        ret += getAlias();
        if (getSelectedOption() != null) {
            ret += " " + getSelectedOption().getAlias();
        }
        double val = getTotalValue();
        for (Adder ad : getAssignedAdders()) {
            if (ad.getXMLID().equals("BURNOUT")) {
                ret += ", " + ad.getAlias();
                continue;
            } else if (ad.getXMLID().equals("JAMMED")) {
                ret += ", " + ad.getAlias();
                continue;
            }
            if (adderString.length() > 0) {
                adderString += ", ";
            }
            adderString += ad.getAlias() + " (" + getFraction(ad.getBaseCost())
                    + ")";
            val -= ad.getBaseCost();
        }
        if (getInput() != null && getInput().trim().length() > 0) {
            if (ret.trim().length() > 0) {
                ret += ":  ";
            }
            ret += getInput();
        }
        for (Modifier mod : getAssignedModifiers()) {
            ret += ", " + mod.getAlias();
        }
        ret += " (";
        if (getComments().trim().length() > 0) {
            ret += getComments() + "; ";
        }

        ret += getFraction(val) + ")";
        if (adderString.trim().length() > 0) {
            if (ret.trim().length() > 0) {
                ret += ", ";
            }
            ret += adderString;
        }
        return ret;
    }

    @Override
    public boolean refreshAddersOnUpdate() {
        return true;
    }
}